///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _TABSECURITY_H
#define _TABSECURITY_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/CRC32.H"

#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabSecurityDialog(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    static HWND hAuthString;
    static HWND hAuthKey;
    static HWND hEncryptKeyLength;
    static HWND hAdminPassword1;
    static HWND hAdminPassword2;

    if(uMsg == WM_INITDIALOG)
    {
        char sText[1024];
		int iLength = 0;

		hAuthString        = GetDlgItem(hWnd, IDC_AUTHSTRING);
        hAuthKey           = GetDlgItem(hWnd, IDC_AUTHKEY);
        hEncryptKeyLength  = GetDlgItem(hWnd, IDC_ENCRYPTKEYLEN);
        hAdminPassword1    = GetDlgItem(hWnd, IDC_ADMINPASSWORD1);
        hAdminPassword2    = GetDlgItem(hWnd, IDC_ADMINPASSWORD2);

        iLength = strlen(gsAuthString);
		sprintf_s(sText, sizeof(sText), "%d bits (CRC: %X)", iLength * 8, FullCRC(gsAuthString, iLength));
		Set_Text(hAuthString, sText);

		iLength = strlen(gsAuthKey);
		sprintf_s(sText, sizeof(sText), "%d bits (CRC: %X)", iLength * 8, FullCRC(gsAuthKey, iLength));
		Set_Text(hAuthKey, sText);

		sprintf_s(sText, sizeof(sText), "%d bits", gdwKeyGenLength * 8);
		Set_Text(hEncryptKeyLength, sText);

		Set_Text(hAdminPassword1, "<Not Implemented>");
		Set_Text(hAdminPassword2, "<Not Implemented>");

        return TRUE;
    }

    if(uMsg == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
